*__TESTIDE____________________________________________________________________________________________
*
*
*  TESTIDE
*     Test 6809 Bus Bridge and IDE interface
*____________________________________________________________________________________________________
; constants

OSRAM		EQU       $0000
OSEND		EQU       $CBFF
OSUTIL		EQU       $C000


IDELO		EQU       $F120			; DATA PORT (LOW BYTE)
IDEERR		EQU       $F121			; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	EQU       $F122			; SECTOR COUNT
IDESECTN	EQU       $F123			; SECTOR NUMBER
IDECYLLO	EQU       $F124			; CYLINDER LOW
IDECYLHI	EQU       $F125			; CYLINDER HIGH
IDEHEAD		EQU       $F126			; DRIVE/HEAD
IDESTTS		EQU       $F127			; READ: STATUS; WRITE: COMMAND
IDEHI		EQU       $F128			; DATA PORT (HIGH BYTE)
IDECTRL		EQU       $F12E			; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		EQU       $F12F			; DRIVE ADDRESS (READ ONLY)


		ORG       $0000

*____________________________________________________________________________________________________


MENU:
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'IDE TEST PROGRAM'
		FCB	$00			; Line terminator

		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'1-> RESET IDE DRIVE'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'2-> CLEAR IDE BUFFER'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'3-> READ IDE STATUS'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'4-> READ IDE SECTOR'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'5-> WRITE IDE SECTOR'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'6-> DUMP BUFFER'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'7-> INIT BUF PATTERN'
		FCB	$00			; Line terminator
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'8-> QUIT'
		FCB	$00			; Line terminator

		SWI
		FCB	34		
		
		
		CMPA	#'1'		
		BNE	NOT1
		JSR	IDE_SOFT_RESET	  	; RESET IDE DRIVE TO BEGIN TEST
		JMP	MENU
NOT1:
		CMPA	#'2'
		BNE	NOT2	
		JSR	DO_CLEAR_BUFFER
		JMP 	MENU	
NOT2:
		CMPA	#'3'
		BNE	NOT3	
		JSR	IDE_GET_ID		; GET IDE HD IDENTIFICATION			
		JMP	MENU
NOT3:
		CMPA	#'4'
		BNE	NOT4	
		JSR	DO_READ_BUFFER
		JMP 	MENU			
NOT4:
		CMPA	#'5'
		BNE	NOT5
		JSR	DO_WRITE_BUFFER				
		JMP	MENU		
NOT5:
		CMPA	#'6'
		BNE	NOT6	
		JSR	DO_DUMP_BUFFER			
		JMP	MENU		
NOT6:		
		CMPA	#'7'
		BNE	NOT7	
		JSR	DO_FILL_BUFF
		JMP	MENU			
NOT7:		
		CMPA	#'8'
		BNE	NOT8
		JMP	BOOTGEN		
NOT8:

		CMPA	#'9'
		BNE	NOT9
		JMP	EXIT		
NOT9:
		JMP	MENU
		
		
DO_CLEAR_BUFFER:		
		LDX	#IDE_SECTOR_BUFFER     	; INITIALIZE SECTOR BUFFER TO KNOWN VALUE $00
		LDY	#$0200
		LDAA    #$00
		JSR	FILL_MEM
		RTS
		
DO_DUMP_BUFFER:		
		LDX	#IDE_SECTOR_BUFFER     	; INITIALIZE X TO SECTOR BUFFER 
		LDD	#IDE_SECTOR_BUFFER     	; INITIALIZE D TO SECTOR BUFFER 
		ADDD	#$0200			; ADD BUFFER SIZE
		PSHS	D			; STORE D
		PULS	Y			; RESTORE Y
		JSR	DUMP_BUFFER		; DUMP THE BUFFER
		RTS
		
DO_READ_BUFFER:		
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA0	     	; 28 BIT VALUE 
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA1		;
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA2		;
	     	LDAA	#%11100000	     	; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	     	STAA	IDE_LBA3		;
	     	JSR	IDE_READ_SECTOR		; READ THE IDE HARD DISK SECTOR
     		RTS
     		

DO_FILL_BUFF:		
		LDA	#$00			; SET A TO 0
		LDX	#IDE_SECTOR_BUFFER     	; INITIALIZE X TO SECTOR BUFFER 
		LDB	#$00			; ADD BUFFER SIZE
FILL_LOOP:
		STAA	,X
		INX
		STAA	,X
		INX
		INCA
		INCB
		CMPB 	#$00
		BNE	FILL_LOOP
		RTS
		
DO_WRITE_BUFFER:		
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA0	     	; 28 BIT VALUE 
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA1		;
	     	LDAA	#$00			; LOAD LBA REGISTERS WITH SECTOR #0 (MBR)
	     	STAA	IDE_LBA2		;
	     	LDAA	#%11100000	     	; ENABLE LBA BITS 5:7=111 IN IDE_LBA3
	     	STAA	IDE_LBA3		;
	     	JSR	IDE_WRITE_SECTOR	; WRITE THE IDE HARD DISK SECTOR
		RTS
	     			
		
ERROR:
EXIT:
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'END IDE TEST PROGRAM'
		FCB	$00			; Line terminator
		SWI
		FCB	$00			; EXIT PROGRAM
		RTS

* MAIN PROGRAM ENDS HERE

*__IDE_READ_SECTOR___________________________________________________________________________________
*
*  READ IDE SECTOR (IN LBA) INTO BUFFER
*     
*____________________________________________________________________________________________________				
IDE_READ_SECTOR:
		JSR	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
		BNE	IDE_READ_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
		LDAA    #$20			;  		
		STAA    IDESTTS			; $20 = IDE 'READ SECTOR' COMMAND 		
		JSR	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
		BNE	IDE_READ_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
		BNE	IDE_READ_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_WAIT_BUFFER		; WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
		BNE	IDE_READ_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_READ_BUFFER		; GRAB THE 256 WORDS FROM THE BUFFER
		CLRA				; ZERO = 1 ON RETURN = OPERATION OK
		RTS
IDE_READ_SECTOR_ERR:
		LDAA    #$FF
		RTS
		
		
*__IDE_WRITE_SECTOR__________________________________________________________________________________
*
*  WRITE IDE SECTOR (IN LBA) FROM BUFFER
*     
*____________________________________________________________________________________________________				
IDE_WRITE_SECTOR:
		JSR	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_SETUP_LBA		; TELL DRIVE WHAT SECTOR IS REQUIRED
		LDAA    #$30			;  
		STAA    IDESTTS			; $30 = IDE 'WRITE SECTOR' COMMAND 
		JSR	IDE_WAIT_BUSY_READY	;
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_WAIT_BUFFER		; WAIT FOR BUFFER READY SIGNAL FROM DRIVE
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_WRITE_BUFFER       	; SEND 256 WORDS TO DRIVE'S BUFFER
		JSR	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		JSR	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
		BNE	IDE_WRITE_SECTOR_ERR	; ERROR, ABORT
		CLRA				; ZERO = 1 ON RETURN = OPERATION OK		
		RTS
IDE_WRITE_SECTOR_ERR:
		LDA	#$FF
		RTS
		
	
*__IDE_GET_ID________________________________________________________________________________________
*
*  GET IDE DEVICE ID STRING
*     
*____________________________________________________________________________________________________				
IDE_GET_ID:      
		JSR	IDE_WAIT_BUSY_READY	;
		BNE	IDE_GET_ID_ERR		; ERROR, ABORT
		LDAA    #%10100000		;
		STAA    IDEHEAD			; SELECT MASTER DEVICE
		JSR	IDE_WAIT_BUSY_READY	;
		BNE	IDE_GET_ID_ERR		; ERROR, ABORT
		LDAA    #$EC			;  
		STAA    IDESTTS			; $EC = IDE 'ID DRIVE' COMMAND 
		JSR	IDE_WAIT_BUSY_READY	; MAKE SURE DRIVE IS READY TO PROCEED
		BNE	IDE_GET_ID_ERR		; ERROR, ABORT
		JSR	IDE_TEST_ERROR		; ENSURE NO ERROR WAS REPORTED
		BNE	IDE_GET_ID_ERR		; ERROR, ABORT
		JSR	IDE_WAIT_BUFFER		; WAIT FOR FULL BUFFER SIGNAL FROM DRIVE
		BNE	IDE_GET_ID_ERR		; ERROR, ABORT
		JSR	IDE_READ_BUFFER_BE  	; GRAB THE 256 WORDS FROM THE BUFFER
		CLRA				; ZERO = 1 ON RETURN = OPERATION OK
		RTS
IDE_GET_ID_ERR:
		LDAA    #$FF
		RTS
		
*__IDE_SOFT_RESET____________________________________________________________________________________
*
*  SOFT RESET IDE CHANNEL
*     
*____________________________________________________________________________________________________				
IDE_SOFT_RESET

		LDAA    #%00000110		; NO INTERRUPTS, RESET DRIVE = 1
		STAA    IDECTRL			;
		LDAA    #%00000010		; NO INTERRUPTS, RESET DRIVE = 0
		STAA    IDECTRL			;
		JSR	IDE_WAIT_BUSY_READY	;
		RTS				;


*__IDE_WAIT_BUSY_READY_______________________________________________________________________________
*
*  WAIT FOR IDE CHANNEL TO BECOME READY
*     
*____________________________________________________________________________________________________				
IDE_WAIT_BUSY_READY:
		
		LDX	#$0000			;

IDE_WBSY:
		PSHS    B			; DELAY
		PULS    B			; DELAY
		INX				;
		CPX	#$1E00			; TIMED OUT?
		BEQ	IDE_TO			; YUP, EXIT
		LDAA    IDESTTS			; READ ERROR REG
		ANDA    #%11000000		; MASK OFF BUSY AND RDY BITS
		CMPA   	#%01000000		; WE WANT BUSY(7) TO BE 0 AND RDY(6) TO BE 1
		BNE	IDE_WBSY		;
		CLRA				; ZERO 1 = OK
		RTS
IDE_TO:
		LDAA    #$FF			; ZERO 0 = TIMED OUT
		CLRA
		RTS
		
*__IDE_TEST_ERROR____________________________________________________________________________________
*
*  TEST FOR IDE ERROR
*     
*____________________________________________________________________________________________________				
IDE_TEST_ERROR:
		
		LDAA    IDESTTS			;
		ANDA    #%00000001		;
		BNE	IDE_ERR			;		
		CLRA				;
		RTS
IDE_ERR:
		LDAA    IDEERR			; READ ERROR FLAGS
		LDAA    #$FF			; ZERO 0 = ERROR
		RTS				;
						;
*__IDE_WAIT_BUFFER____________________________________________________________________________________
*
*  WAIT FOR IDE BUFFER TO FILL
*     
*____________________________________________________________________________________________________				
IDE_WAIT_BUFFER:
		
		LDX	#$0000			;

IDE_WDRQ:
		PSHS    B			;
		PULS    B			;
		PSHS    B			;
		PULS    B			;		
		INX				;
		CPX	#$FFFF			;
		BEQ	IDE_TO2			;
		LDAA    IDESTTS			; WAIT FOR DRIVE'S 512 BYTE READ BUFFER 
		ANDA    #%00001000		;
		BNE	IDE_WDRQ		;
		JMP	IDE_WDRQ
		CLRA				; ZERO 1 = OK
		RTS
IDE_TO2:
		LDAA    #$FF			; CARRY 0 = TIMED OUT
		CLRA
		RTS

*__IDE_READ_BUFFER_BE________________________________________________________________________________
*
*  READ IDE BUFFER BIG ENDIAN
*     
*____________________________________________________________________________________________________				
IDE_READ_BUFFER_BE:
		PSHS    X			;
		LDX	#IDE_SECTOR_BUFFER	;
		LDAB    #$00			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFRD_BE:
		LDAA    IDELO			; LOW BYTE OF WORD FIRST	 
		STAA    1,X			; 'ID DRIVE' IDE RESPONSE IS LITTLE ENDIAN FORMAT
		LDAA    IDEHI			; THEN HIGH BYTE OF WORD
		STAA    ,X++			; 'ID DRIVE' IDE RESPONSE IS LITTLE ENDIAN FORMAT
		DECB     			;
		CMPB    #$00			;
		BNE	IDEBUFRD_BE		;
		PULS    X			;
		RTS				;
		
*__IDE_READ_BUFFER___________________________________________________________________________________
*
*  READ IDE BUFFER LITTLE ENDIAN
*     
*____________________________________________________________________________________________________				
IDE_READ_BUFFER:
		PSHS    X			;
		LDX	#IDE_SECTOR_BUFFER	;
		LDY    	#$0100			; 256 WORDS (512 BYTES PER SECTOR)
IDEBUFRD:
		LDAA    IDELO			; LOW BYTE OF WORD FIRST
		LDAB    IDEHI			; THEN HIGH BYTE OF WORD
		STAA    ,X+			; 'ID DRIVE' IDE RESPONSE IS LITTLE ENDIAN FORMAT		
		STAB    ,X+			; 'ID DRIVE' IDE RESPONSE IS LITTLE ENDIAN FORMAT
		DEY     			;
		CMPY    #$0000			;
		BNE	IDEBUFRD		;
		PULS    X			;
		RTS				;
*__IDE_WRITE_BUFFER___________________________________________________________________________________
*
*  WRITE IDE BUFFER LITTLE ENDIAN
*     
*____________________________________________________________________________________________________				
IDE_WRITE_BUFFER:
		PSHS    X			;
		LDX	#IDE_SECTOR_BUFFER	;
		LDAB    #$00			; 256 WORDS (512 BYTES PER SECTOR)

IDEBUFWT:
		LDAA    1,X			; SECTORS ARE BIG ENDIAN
		STAA    IDEHI			; SET UP HIGH LATCHED BYTE BEFORE
		LDAA    ,X++			; SECTORS ARE BIG ENDIAN
		STAA    IDELO			; WRITING WORD WITH WRITE TO LOW BYTE
		DECB     			;
		CMPB    #$00			;
		BNE	IDEBUFWT		;
		PULS    X			;
		RTS				;
		
*__IDE_SETUP_LBA_____________________________________________________________________________________
*
*  SETUP LBA DATA
*     
*____________________________________________________________________________________________________				
IDE_SETUP_LBA:	      
		LDAA    #$01			;  
		STAA    IDESECTC		; SET SECTOR COUNT = 1		
		LDAA    IDE_LBA0		;
		STAA    IDESECTN		; SET LBA 0:7
		LDAA    IDE_LBA1		;
		STAA    IDECYLLO		; SET LBA 8:15
		LDAA    IDE_LBA2		;
		STAA    IDECYLHI		; SET LBA 16:23
		LDAA    IDE_LBA3		;
		ANDA    #%00001111		; LOWEST 4 BITS USED ONLY
		ORA     #%11100000		; TO ENABLE LBA MODE
		STAA    IDEHEAD			; SET LBA 24:27 + BITS 5:7=111
		RTS
		
*__FILL_MEM__________________________________________________________________________________________
*
*  FILL MEMORY BLOCK
*     
*____________________________________________________________________________________________________				
FILL_MEM:
		STAA    ,X+			;
		DEY				;
		CMPY    #$0000			;
		BNE	FILL_MEM		;
		RTS				;
		

*__DUMP__________________________________________________________________________________________________________________________ 
*
*	Print a Memory Dump (LOW)
*________________________________________________________________________________________________________________________________
*
DUMP_BUFFER:
		STY	TEMPW1			; STORE END
		STX	TEMPW			; STORE START 
		SWI				;
		FCB	22			; OUTPUT CRLF
BLKRD:		
		LDD	TEMPW			;
		SWI
		FCB	27			; PRINT START LOCATION
		SWI				;
		FCB	21			; PRINT SPACE
		LDY	#$10			; SET FOR 16 LOCS
NXTONE:
		LDAA	,X+			; GET BYTE
		SWI				;
		FCB	28			; PRINT VALUE
		SWI				;
		FCB	21			; PRINT SPACE
UPDH:	
		DEY				; DEC. LOC COUNT
		BNE	NXTONE			; IF LINE NOT DONE
						; NOW PRINT 'DECODED' DATA TO RIGHT OF DUMP
PCRLF:
		SWI				;
		FCB	21			; PRINT SPACE
		LDY	#$10			; SET FOR 16 LOCS
		LDX	TEMPW			; GET BACK START
PCRLF0:
		LDAA	,X+			; GET BYTE
		CMPA	#$20			; SEE IF A 'DOT'
		BGT	PDOT			; O.K. TO GET
		LDAA	#$2E			; LOAD A DOT	
PDOT:
		SWI				
		FCB	33			; PRINT IT
		DEY				; DEC. LOC COUNT		
		BNE	PCRLF0			; IF LINE NOT DONE
		SWI				
		FCB	22			; PRINT CRLF
		CPX	TEMPW1			;
		BGT	DUMP_END		;
		STX	TEMPW			;
CONTD:
		JMP	BLKRD			;

DUMP_END:	
		RTS				;
	
TEMPW:
		FCW	$01			;		
TEMPW1:		
		FCW	$01			;						
; DATA MEMORY RESERVED RANGES FOR VARIABLES AND SECTOR BUFFER


IDE_LBA0:
		FCB	$01			; SET LBA 0:7
IDE_LBA1:
		FCB	$01			; SET LBA 8:15
IDE_LBA2:
		FCB	$01			; SET LBA 16:23
IDE_LBA3:
		FCB	$01			; LOWEST 4 BITS USED ONLY 
						; TO ENABLE LBA MODE 
						; SET LBA 24:27 + BITS 5:7=111
IDE_SECTOR_BUFFER:
		RMB      $0200









*_________________________________________________________________________________________________________________________



